/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.datastore.neo4j.EmbeddedNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jGraphDatabaseServiceFactoryProvider;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jSchemaDefiner;
import org.hibernate.ogm.datastore.neo4j.embedded.transaction.impl.EmbeddedNeo4jTransactionCoordinatorBuilder;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jBasedQueryParserService;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.neo4j.graphdb.GraphDatabaseService;

public class EmbeddedNeo4jDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final int DEFAULT_SEQUENCE_QUERY_CACHE_MAX_SIZE = 128;
    private static Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private GraphDatabaseService neo4jDb;
    private GraphDatabaseServiceFactory graphDbFactory;
    private ServiceRegistryImplementor registry;
    private EmbeddedNeo4jSequenceGenerator sequenceGenerator;
    private Integer sequenceCacheMaxSize;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.registry = serviceRegistry;
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return Neo4jBasedQueryParserService.class;
    }

    public void configure(Map cfg) {
        this.graphDbFactory = new EmbeddedNeo4jGraphDatabaseServiceFactoryProvider().load(cfg, (ClassLoaderService)this.registry.getService(ClassLoaderService.class));
        this.sequenceCacheMaxSize = (Integer)new ConfigurationPropertyReader(cfg).property("hibernate.ogm.neo4j.sequence_query_cache_max_size", Integer.TYPE).withDefault((Object)128).getValue();
    }

    public void stop() {
        this.neo4jDb.shutdown();
    }

    public void start() {
        try {
            this.neo4jDb = this.graphDbFactory.create();
            this.sequenceGenerator = new EmbeddedNeo4jSequenceGenerator(this.neo4jDb, this.sequenceCacheMaxSize);
            this.graphDbFactory = null;
            this.sequenceCacheMaxSize = null;
        }
        catch (Exception e) {
            throw LOG.unableToStartDatastoreProvider(e);
        }
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return EmbeddedNeo4jDialect.class;
    }

    public GraphDatabaseService getDatabase() {
        return this.neo4jDb;
    }

    public EmbeddedNeo4jSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return EmbeddedNeo4jSchemaDefiner.class;
    }

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder(TransactionCoordinatorBuilder coordinatorBuilder) {
        return new EmbeddedNeo4jTransactionCoordinatorBuilder(coordinatorBuilder, this);
    }
}

