/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.jboss.logging.Logger;
import org.neo4j.graphdb.Label;

public abstract class BaseNeo4jSchemaDefiner
extends BaseSchemaDefiner {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    protected void createUniqueConstraints(DatastoreProvider provider, Database database) {
        ArrayList<UniqueConstraintDetails> constraints = new ArrayList<UniqueConstraintDetails>();
        for (Namespace namespace : database.getNamespaces()) {
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable()) continue;
                Label label = Label.label((String)table.getName());
                PrimaryKey primaryKey = table.getPrimaryKey();
                this.addConstraint(constraints, table, label, (Constraint)primaryKey);
                Iterator columnIterator = table.getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column column = (Column)columnIterator.next();
                    if (!column.isUnique()) continue;
                    constraints.add(new UniqueConstraintDetails(label, column.getName()));
                }
                Iterator uniqueKeyIterator = table.getUniqueKeyIterator();
                while (uniqueKeyIterator.hasNext()) {
                    this.addConstraint(constraints, table, label, (Constraint)uniqueKeyIterator.next());
                }
            }
        }
        this.createUniqueConstraintsIfMissing(provider, constraints);
    }

    private void addConstraint(List<UniqueConstraintDetails> constraints, Table table, Label label, Constraint constraint) {
        if (constraint != null && !this.isAppliedToForeignColumns(table, constraint)) {
            if (constraint.getColumnSpan() == 1) {
                String propertyName = constraint.getColumn(0).getName();
                constraints.add(new UniqueConstraintDetails(label, propertyName));
            } else if (log.isEnabled(Logger.Level.WARN)) {
                this.logMultipleColumnsWarning(table, constraint);
            }
        }
    }

    private boolean isAppliedToForeignColumns(Table table, Constraint constraint) {
        List constraintColumns = constraint.getColumns();
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            List foreignKeyColumns = foreignKey.getColumns();
            for (Object object : foreignKeyColumns) {
                if (!constraintColumns.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    private void logMultipleColumnsWarning(Table table, Constraint constraint) {
        StringBuilder builder = new StringBuilder();
        Iterator columnIterator = constraint.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            builder.append(", ");
            builder.append(column.getName());
        }
        String columns = "[" + builder.substring(2) + "]";
        log.constraintSpanningMultipleColumns(constraint.getName(), table.getName(), columns);
    }

    protected List<Sequence> sequences(Database database) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (Namespace namespace : database.getNamespaces()) {
            for (Sequence sequence : namespace.getSequences()) {
                sequences.add(sequence);
            }
        }
        return sequences;
    }

    protected void createEntityConstraints(DatastoreProvider provider, Database database, Properties properties) {
        UniqueConstraintSchemaUpdateStrategy constraintMethod = UniqueConstraintSchemaUpdateStrategy.interpret((Object)properties.get("hibernate.schema_update.unique_constraint_strategy"));
        log.debugf("%1$s property set to %2$s", "hibernate.schema_update.unique_constraint_strategy", constraintMethod);
        if (constraintMethod == UniqueConstraintSchemaUpdateStrategy.SKIP) {
            log.tracef("Skipping generation of unique constraints", new Object[0]);
        } else {
            this.createUniqueConstraints(provider, database);
        }
    }

    public void initializeSchema(SchemaDefiner.SchemaDefinitionContext context) {
        SessionFactoryImplementor sessionFactoryImplementor = context.getSessionFactory();
        ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
        DatastoreProvider provider = (DatastoreProvider)registry.getService(DatastoreProvider.class);
        List<Sequence> sequences = this.sequences(context.getDatabase());
        this.createSequences(sequences, context.getAllIdSourceKeyMetadata(), provider);
        this.createEntityConstraints(provider, context.getDatabase(), sessionFactoryImplementor.getProperties());
    }

    protected abstract void createSequences(List<Sequence> var1, Set<IdSourceKeyMetadata> var2, DatastoreProvider var3);

    protected abstract void createUniqueConstraintsIfMissing(DatastoreProvider var1, List<UniqueConstraintDetails> var2);

    public static class UniqueConstraintDetails {
        private final Label label;
        private final String property;

        public UniqueConstraintDetails(Label label, String property) {
            this.label = label;
            this.property = property;
        }

        public Label getLabel() {
            return this.label;
        }

        public String getProperty() {
            return this.property;
        }

        public String asCypherQuery() {
            StringBuilder queryBuilder = new StringBuilder("CREATE CONSTRAINT ON (n:");
            CypherDSL.escapeIdentifier(queryBuilder, this.label.name());
            queryBuilder.append(") ASSERT n.");
            CypherDSL.escapeIdentifier(queryBuilder, this.property);
            queryBuilder.append(" IS UNIQUE");
            String query = queryBuilder.toString();
            return query;
        }

        public String toString() {
            return "UniqueConstraintDetails [label=" + this.label + ", property=" + this.property + "]";
        }
    }
}

