/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.request.impl.RemoteStatement;
import org.hibernate.ogm.datastore.neo4j.remote.common.request.impl.RemoteStatements;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public abstract class RemoteNeo4jSequenceGenerator
extends BaseNeo4jSequenceGenerator {
    protected static final String SEQUENCE_CREATION_QUERY = "MERGE (n:" + NodeLabel.SEQUENCE.name() + " {" + "sequence_name" + ": {sequenceName}} ) RETURN n";
    protected static final String SEQUENCE_LOCK_QUERY = "MATCH (n:" + NodeLabel.SEQUENCE.name() + ") WHERE n." + "sequence_name" + " = {sequenceName}  SET n.__locked = true  RETURN n";
    protected static final String SEQUENCE_VALUE_QUERY = "MATCH (n:" + NodeLabel.SEQUENCE.name() + ") WHERE n." + "sequence_name" + " = {sequenceName}  REMOVE n.__locked  SET n." + "next_val" + " = coalesce(n." + "next_val" + ", {initialValue}) + {increment} RETURN n." + "next_val";
    private static final Log logger = LoggerFactory.make(MethodHandles.lookup());
    private final BoundedConcurrentHashMap<String, RemoteStatements> queryCache;

    public RemoteNeo4jSequenceGenerator(int sequenceCacheMaxSize) {
        this.queryCache = new BoundedConcurrentHashMap(sequenceCacheMaxSize, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    @Override
    public Long nextValue(NextValueRequest request) {
        String sequenceName = this.sequenceName(request.getKey());
        RemoteStatements remoteStatements = this.updateNextValueQuery(request);
        Number nextValue = this.nextValue(remoteStatements);
        if (request.getKey().getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE && nextValue == null) {
            throw logger.sequenceNotFound(sequenceName);
        }
        return nextValue.longValue() - (long)request.getIncrement();
    }

    protected abstract Number nextValue(RemoteStatements var1);

    protected String increaseQuery(NextValueRequest request) {
        StringBuilder queryBuilder = new StringBuilder();
        IdSourceKeyMetadata metadata = request.getKey().getMetadata();
        queryBuilder.append(" MATCH (n ");
        queryBuilder.append(this.labels(metadata.getName(), NodeLabel.TABLE_BASED_SEQUENCE.name()));
        queryBuilder.append(" { ");
        queryBuilder.append(metadata.getKeyColumnName());
        queryBuilder.append(": {");
        queryBuilder.append("sequenceName");
        queryBuilder.append("}} )");
        queryBuilder.append(" SET n.");
        queryBuilder.append(metadata.getValueColumnName());
        queryBuilder.append(" = n.");
        queryBuilder.append(metadata.getValueColumnName());
        queryBuilder.append(" + ");
        queryBuilder.append(request.getIncrement());
        queryBuilder.append(" REMOVE n.__locked RETURN n.");
        queryBuilder.append(metadata.getValueColumnName());
        String query = queryBuilder.toString();
        return query;
    }

    protected String acquireLockQuery(NextValueRequest request) {
        StringBuilder queryBuilder = new StringBuilder();
        IdSourceKeyMetadata metadata = request.getKey().getMetadata();
        queryBuilder.append("MERGE (n");
        queryBuilder.append(this.labels(metadata.getName(), NodeLabel.TABLE_BASED_SEQUENCE.name()));
        queryBuilder.append(" { ");
        queryBuilder.append(metadata.getKeyColumnName());
        queryBuilder.append(": {");
        queryBuilder.append("sequenceName");
        queryBuilder.append("}} ) ");
        queryBuilder.append(" ON MATCH SET n.__locked=true ");
        queryBuilder.append(" ON CREATE SET n.__locked=true, n.");
        queryBuilder.append(metadata.getValueColumnName());
        queryBuilder.append(" = ");
        queryBuilder.append(request.getInitialValue());
        queryBuilder.append(" RETURN n.");
        queryBuilder.append(metadata.getValueColumnName());
        String query = queryBuilder.toString();
        return query;
    }

    protected RemoteStatements updateNextValueQuery(NextValueRequest request) {
        return request.getKey().getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? this.getTableQuery(request) : this.getSequenceIncrementQuery(request);
    }

    private RemoteStatements getSequenceIncrementQuery(NextValueRequest request) {
        String sequenceName = this.sequenceName(request.getKey());
        RemoteStatement lockStatement = new RemoteStatement(SEQUENCE_LOCK_QUERY, Collections.singletonMap("sequenceName", sequenceName));
        RemoteStatements statements = new RemoteStatements();
        statements.addStatement(lockStatement);
        String query = SEQUENCE_VALUE_QUERY.replace("{increment}", String.valueOf(request.getIncrement())).replace("{initialValue}", String.valueOf(request.getInitialValue()));
        RemoteStatement statement = new RemoteStatement(query, this.params(request), true);
        statements.addStatement(statement);
        return statements;
    }

    private RemoteStatements getTableQuery(NextValueRequest request) {
        String key = this.key(request);
        RemoteStatements statements = (RemoteStatements)this.queryCache.get((Object)key);
        if (statements == null) {
            statements = new RemoteStatements();
            this.getUpdateTableSequenceQuery(statements, request);
            RemoteStatements cached = (RemoteStatements)this.queryCache.putIfAbsent((Object)key, (Object)statements);
            if (cached != null) {
                statements = cached;
            }
        }
        return statements;
    }

    private void getUpdateTableSequenceQuery(RemoteStatements statements, NextValueRequest request) {
        Map<String, Object> params = this.params(request);
        String acquireLockQuery = this.acquireLockQuery(request);
        RemoteStatement acquireLockStatement = new RemoteStatement(acquireLockQuery, params, true);
        statements.addStatement(acquireLockStatement);
        String updateQuery = this.increaseQuery(request);
        RemoteStatement updateStatement = new RemoteStatement(updateQuery, params, true);
        statements.addStatement(updateStatement);
    }

    public abstract void createSequences(List<Sequence> var1, Iterable<IdSourceKeyMetadata> var2);
}

