/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl;

import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.remote.common.util.impl.RemoteNeo4jHelper;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;

public final class RemoteNeo4jAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, Tuple> tuples;

    public RemoteNeo4jAssociationSnapshot(Map<RowKey, Tuple> tuples) {
        this.tuples = tuples;
    }

    public Tuple get(RowKey rowKey) {
        Tuple tuple = this.tuples.get(rowKey);
        if (tuple == null) {
            for (Map.Entry<RowKey, Tuple> entry : this.tuples.entrySet()) {
                if (!RemoteNeo4jHelper.matches(entry.getKey(), rowKey)) continue;
                return entry.getValue();
            }
        }
        return tuple;
    }

    public boolean containsKey(RowKey rowKey) {
        return this.tuples.containsKey(rowKey);
    }

    public int size() {
        return this.tuples.size();
    }

    public Set<RowKey> getRowKeys() {
        return this.tuples.keySet();
    }
}

