/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.common.impl;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jConfiguration;

public class RemoteNeo4jDatabaseIdentifier {
    private static final String SLASH = "/";
    private final String host;
    private final int port;
    private final String databaseName;
    private final String username;
    private final String password;
    private final String serverUri;
    private final String databaseUri;

    public RemoteNeo4jDatabaseIdentifier(String protocol, RemoteNeo4jConfiguration configuration) throws MalformedURLException, URISyntaxException {
        Hosts.HostAndPort first = configuration.getHosts().getFirst();
        this.host = first.getHost();
        this.port = first.getPort();
        this.databaseName = configuration.getDatabaseName();
        this.username = configuration.getUsername();
        this.password = configuration.getPassword();
        this.serverUri = protocol + "://" + this.host + ":" + this.port;
        this.databaseUri = this.serverUri + SLASH + this.databaseName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getDatabaseUri() {
        return this.databaseUri;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "RemoteNeo4jDatabaseIdentifier [host=" + this.host + ", port=" + this.port + ", databaseName=" + this.databaseName + ", userName=" + this.username + ", password=***, serverUri=" + this.serverUri + ", databaseUri=" + this.databaseUri + "]";
    }
}

