/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.Arrays;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jAssociationQueries;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.types.Relationship;

public class BoltNeo4jAssociationQueries
extends BaseNeo4jAssociationQueries {
    public BoltNeo4jAssociationQueries(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        super(ownerEntityKeyMetadata, associationKeyMetadata);
    }

    public void removeAssociation(Transaction tx, AssociationKey associationKey) {
        tx.run(this.removeAssociationQuery, this.params(associationKey.getEntityKey().getColumnValues()));
    }

    public Relationship findRelationship(Transaction tx, AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues = this.relationshipValues(associationKey, rowKey);
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        StatementResult result = tx.run(this.findRelationshipQuery, this.params(queryValues));
        return this.relationship(result);
    }

    private Relationship relationship(StatementResult result) {
        if (result.hasNext()) {
            return result.next().get(0).asRelationship();
        }
        return null;
    }

    public Relationship createRelationshipForEmbeddedAssociation(Transaction tx, AssociationKey associationKey, EntityKey embeddedKey, Object[] relationshipProperties) {
        String query = this.initCreateEmbeddedAssociationQuery(associationKey, embeddedKey);
        Object[] queryValues = this.createRelationshipForEmbeddedQueryValues(associationKey, embeddedKey, relationshipProperties);
        StatementResult statementResult = tx.run(query, this.params(queryValues));
        return this.relationship(statementResult);
    }

    public Relationship createRelationship(Transaction tx, Object[] ownerKeyValues, Object[] targetKeyValues, Object[] relationshipProperties) {
        Object[] concat = ArrayHelper.concat(Arrays.asList(ownerKeyValues, targetKeyValues, relationshipProperties));
        Map<String, Object> params = this.params(concat);
        StatementResult statementResult = tx.run(this.createRelationshipQuery, params);
        return this.relationship(statementResult);
    }

    public void removeAssociationRow(Transaction tx, AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues = this.relationshipValues(associationKey, rowKey);
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        tx.run(this.removeAssociationRowQuery, this.params(queryValues));
    }
}

