/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.RelationshipAliasTree;
import org.hibernate.ogm.util.impl.StringHelper;

public class Neo4jAliasResolver {
    private final Map<String, String> aliasByEntityName = new HashMap<String, String>();
    private final Map<String, RelationshipAliasTree> relationshipAliases = new HashMap<String, RelationshipAliasTree>();
    private final Set<String> optionalMatches = new HashSet<String>();
    private final Set<String> requiredMatches = new HashSet<String>();
    private int relationshipCounter = 0;

    public void registerEntityAlias(String entityName, String alias) {
        this.aliasByEntityName.put(entityName, alias);
    }

    public String findAliasForType(String entityType) {
        return this.aliasByEntityName.get(entityType);
    }

    public String createAliasForEmbedded(String entityAlias, List<String> propertyPathWithoutAlias, boolean optionalMatch) {
        return this.createAliasForRelationship(entityAlias, propertyPathWithoutAlias, NodeLabel.EMBEDDED.name(), optionalMatch);
    }

    public String createAliasForAssociation(String entityAlias, List<String> propertyPathWithoutAlias, String targetNodeType, boolean optionalMatch) {
        return this.createAliasForRelationship(entityAlias, propertyPathWithoutAlias, targetNodeType, optionalMatch);
    }

    private String createAliasForRelationship(String entityAlias, List<String> propertyPathWithoutAlias, String targetEntityName, boolean optionalMatch) {
        RelationshipAliasTree relationshipAlias = this.relationshipAliases.get(entityAlias);
        if (relationshipAlias == null) {
            relationshipAlias = RelationshipAliasTree.root(entityAlias);
            this.relationshipAliases.put(entityAlias, relationshipAlias);
        }
        for (int i = 0; i < propertyPathWithoutAlias.size(); ++i) {
            String name = propertyPathWithoutAlias.get(i);
            RelationshipAliasTree child = relationshipAlias.findChild(name);
            if (child == null) {
                if (i != propertyPathWithoutAlias.size() - 1) {
                    throw new AssertionFailure("The path to " + StringHelper.join(propertyPathWithoutAlias, (String)".") + " has not been completely constructed");
                }
                ++this.relationshipCounter;
                String childAlias = "_" + entityAlias + this.relationshipCounter;
                child = RelationshipAliasTree.relationship(childAlias, name, targetEntityName);
                relationshipAlias.addChild(child);
            }
            relationshipAlias = child;
            String alias = relationshipAlias.getAlias();
            if (optionalMatch && !this.requiredMatches.contains(alias)) {
                this.optionalMatches.add(alias);
                continue;
            }
            this.requiredMatches.add(alias);
            this.optionalMatches.remove(alias);
        }
        return relationshipAlias.getAlias();
    }

    public String findAlias(String entityAlias, List<String> propertyPathWithoutAlias) {
        RelationshipAliasTree aliasTree = this.relationshipAliases.get(entityAlias);
        if (aliasTree == null) {
            return null;
        }
        RelationshipAliasTree associationAlias = aliasTree;
        for (int i = 0; i < propertyPathWithoutAlias.size(); ++i) {
            if ((associationAlias = associationAlias.findChild(propertyPathWithoutAlias.get(i))) != null) continue;
            return null;
        }
        return associationAlias.getAlias();
    }

    public RelationshipAliasTree getRelationshipAliasTree(String entityAlias) {
        return this.relationshipAliases.get(entityAlias);
    }

    public boolean isOptionalMatch(String alias) {
        return this.optionalMatches.contains(alias);
    }
}

