/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jConfiguration;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatabaseIdentifier;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class BoltNeo4jClient {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Driver driver;

    public BoltNeo4jClient(RemoteNeo4jDatabaseIdentifier identifier, RemoteNeo4jConfiguration configuration) {
        this.driver = this.createNeo4jDriver(identifier, configuration);
    }

    public BoltNeo4jClient(Driver driver) {
        this.driver = driver;
    }

    private Driver createNeo4jDriver(RemoteNeo4jDatabaseIdentifier identifier, RemoteNeo4jConfiguration configuration) {
        String uri = identifier.getDatabaseUri();
        try {
            if (configuration.isAuthenticationRequired()) {
                AuthToken authToken = AuthTokens.basic((String)configuration.getUsername(), (String)configuration.getPassword());
                return GraphDatabase.driver((String)uri, (AuthToken)authToken);
            }
            return GraphDatabase.driver((String)uri);
        }
        catch (Neo4jException e) {
            throw log.connectionFailed(uri, e.code(), e.getMessage());
        }
    }

    public void close() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    public Driver getDriver() {
        return this.driver;
    }
}

