/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.codec.Base16;
import com.lambdaworks.redis.RedisException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class LettuceStrings {
    private LettuceStrings() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !LettuceStrings.isEmpty(cs);
    }

    public static String string(double n) {
        if (Double.isInfinite(n)) {
            return n > 0.0 ? "+inf" : "-inf";
        }
        return Double.toString(n);
    }

    public static String digest(byte[] script) {
        return LettuceStrings.digest(ByteBuffer.wrap(script));
    }

    public static String digest(ByteBuffer script) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(script);
            return new String(Base16.encode(md.digest(), false));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RedisException("JVM does not support SHA1");
        }
    }
}

