/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceFactories;
import com.lambdaworks.redis.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class NestedMultiOutput<K, V>
extends CommandOutput<K, V, List<Object>> {
    private final Deque<List<Object>> stack = LettuceFactories.newSpScQueue();
    private int depth = 0;

    public NestedMultiOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
    }

    @Override
    public void set(long integer) {
        ((List)this.output).add(integer);
    }

    @Override
    public void set(ByteBuffer bytes) {
        ((List)this.output).add(bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void setError(ByteBuffer error) {
        ((List)this.output).add(new RedisCommandExecutionException(this.decodeAscii(error)));
    }

    @Override
    public void complete(int depth) {
        if (depth > 0 && depth < this.depth) {
            this.output = this.stack.pop();
            --this.depth;
        }
    }

    @Override
    public void multi(int count) {
        ArrayList a = new ArrayList(count);
        ((List)this.output).add(a);
        this.stack.push((List<Object>)this.output);
        this.output = a;
        ++this.depth;
    }
}

