/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.model.impl;

import java.util.Collection;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisHashTupleSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.value.HashEntity;
import org.hibernate.ogm.datastore.redis.dialect.value.StructuredValue;
import org.hibernate.ogm.datastore.redis.logging.impl.Log;
import org.hibernate.ogm.datastore.redis.logging.impl.LoggerFactory;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationType;

class HashEmbeddedAssociation
extends RedisAssociation {
    private static final Log log = LoggerFactory.getLogger();
    private final TuplePointer tuplePointer;
    private final AssociationKeyMetadata associationKeyMetadata;

    public HashEmbeddedAssociation(TuplePointer tuplePointer, AssociationKeyMetadata associationKeyMetadata) {
        this.associationKeyMetadata = associationKeyMetadata;
        this.tuplePointer = tuplePointer;
    }

    @Override
    public Object getRows() {
        return this.getEntity().get(this.associationKeyMetadata.getCollectionRole());
    }

    @Override
    public void setRows(Object rows) {
        if (this.isEmpty(rows)) {
            this.getEntity().set(this.associationKeyMetadata.getCollectionRole(), null);
        } else if (this.associationKeyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE && rows instanceof Collection) {
            Object value = ((Collection)rows).iterator().next();
            this.getEntity().set(this.associationKeyMetadata.getCollectionRole(), (String)value);
        } else {
            throw log.embeddedToManyAssociationsNotSupportByRedisHash(this.associationKeyMetadata.getEntityKeyMetadata().getTable(), this.associationKeyMetadata.getCollectionRole());
        }
    }

    protected boolean isEmpty(Object rows) {
        if (rows == null) {
            return true;
        }
        return rows instanceof Collection && ((Collection)rows).isEmpty();
    }

    @Override
    public StructuredValue getOwningDocument() {
        return this.getEntity();
    }

    private HashEntity getEntity() {
        return ((RedisHashTupleSnapshot)this.tuplePointer.getTuple().getSnapshot()).getEntity();
    }
}

