/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.redis.RedisJsonDialect;
import org.hibernate.ogm.datastore.redis.impl.RedisConfiguration;
import org.hibernate.ogm.datastore.redis.logging.impl.Log;
import org.hibernate.ogm.datastore.redis.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class RedisDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log log = LoggerFactory.getLogger();
    private ServiceRegistryImplementor serviceRegistry;
    private RedisConfiguration config;
    private AbstractRedisClient redisClient;
    private StatefulConnection<String, String> connection;

    public Class<? extends GridDialect> getDefaultDialect() {
        return RedisJsonDialect.class;
    }

    public void configure(Map configurationValues) {
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        try {
            this.config = new RedisConfiguration(propertyReader);
        }
        catch (Exception e) {
            throw log.unableToConfigureDatastoreProvider(e);
        }
    }

    public void start() {
        try {
            if (this.config.isCluster()) {
                RedisClusterClient clusterClient = this.createClusterClient(this.config.getHosts());
                this.redisClient = clusterClient;
                log.connectingToRedis(this.config.getHosts().toString(), this.config.getTimeout());
                this.connection = clusterClient.connect((RedisCodec)new Utf8StringCodec());
            } else {
                RedisClient client = this.createClient(this.config.getHosts().getFirst());
                this.redisClient = client;
                log.connectingToRedis(this.config.getHosts().toString(), this.config.getTimeout());
                this.connection = client.connect((RedisCodec)new Utf8StringCodec());
            }
        }
        catch (RuntimeException e) {
            throw log.unableToInitializeRedis(e);
        }
    }

    protected RedisClient createClient(Hosts.HostAndPort hostAndPort) {
        RedisURI builder = this.configureRedisUri(hostAndPort);
        return RedisClient.create((RedisURI)builder);
    }

    private RedisURI configureRedisUri(Hosts.HostAndPort hostAndPort) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)hostAndPort.getHost(), (int)hostAndPort.getPort());
        builder.withSsl(this.config.isSsl());
        builder.withDatabase(this.config.getDatabaseNumber());
        if (this.config.getPassword() != null) {
            builder.withPassword(this.config.getPassword());
        }
        builder.withTimeout(this.config.getTimeout(), TimeUnit.MILLISECONDS);
        return builder.build();
    }

    protected RedisClusterClient createClusterClient(Hosts hosts) {
        ArrayList<RedisURI> redisURIs = new ArrayList<RedisURI>();
        for (Hosts.HostAndPort hostAndPort : hosts) {
            redisURIs.add(this.configureRedisUri(hostAndPort));
        }
        return RedisClusterClient.create(redisURIs);
    }

    public void stop() {
        if (this.connection != null) {
            log.disconnectingFromRedis();
            this.connection.close();
            this.connection = null;
            this.shutdownClient();
        }
    }

    protected void shutdownClient() {
        this.redisClient.shutdown(100L, 100L, TimeUnit.MILLISECONDS);
        this.redisClient = null;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public boolean allowsTransactionEmulation() {
        return true;
    }

    public RedisClusterCommands<String, String> getConnection() {
        if (this.connection instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)this.connection).sync();
        }
        if (this.connection instanceof StatefulRedisClusterConnection) {
            return ((StatefulRedisClusterConnection)this.connection).sync();
        }
        throw new IllegalStateException("Connection type " + this.connection + " not supported");
    }

    public boolean isCluster() {
        return this.config.isCluster();
    }
}

