/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class ScopedAnalyzer
extends DelegatingAnalyzerWrapper {
    private static final Analyzer DEFAULT_ANALYZER = new KeywordAnalyzer();
    private final Map<String, Analyzer> scopedAnalyzers;

    private ScopedAnalyzer(Map<String, Analyzer> scopedAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.scopedAnalyzers = CollectionHelper.toImmutableMap(scopedAnalyzers);
    }

    protected Analyzer getWrappedAnalyzer(String absoluteFieldPath) {
        Analyzer analyzer = this.scopedAnalyzers.get(absoluteFieldPath);
        if (analyzer == null) {
            return DEFAULT_ANALYZER;
        }
        return analyzer;
    }

    public static class Builder {
        private final Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

        public void setAnalyzer(String absoluteFieldPath, Analyzer analyzer) {
            this.scopedAnalyzers.put(absoluteFieldPath, analyzer);
        }

        public ScopedAnalyzer build() {
            return new ScopedAnalyzer(this.scopedAnalyzers);
        }
    }
}

