/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneFlattenedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.impl.LuceneNestedObjectDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneDocumentBuilder
implements LuceneDocumentBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final LuceneIndexSchemaObjectNode schemaNode;
    private List<LuceneFlattenedObjectDocumentBuilder> flattenedObjectDocumentBuilders;
    private List<LuceneNestedObjectDocumentBuilder> nestedObjectDocumentBuilders;

    protected AbstractLuceneDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        this.schemaNode = schemaNode;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        LuceneIndexFieldReference luceneFieldReference = (LuceneIndexFieldReference)fieldReference;
        if (!luceneFieldReference.isEnabled()) {
            return;
        }
        LuceneIndexSchemaFieldNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.checkTreeConsistency(fieldSchemaNode.getParent());
        fieldSchemaNode.getCodec().encode(this, fieldSchemaNode.getAbsoluteFieldPath(), value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        LuceneIndexObjectFieldReference luceneFieldReference = (LuceneIndexObjectFieldReference)fieldReference;
        if (!luceneFieldReference.isEnabled()) {
            return NoOpDocumentElement.get();
        }
        LuceneIndexSchemaObjectNode fieldSchemaNode = luceneFieldReference.getSchemaNode();
        this.checkTreeConsistency(fieldSchemaNode.getParent());
        switch (luceneFieldReference.getStorage()) {
            case NESTED: {
                LuceneNestedObjectDocumentBuilder nestedDocumentBuilder = new LuceneNestedObjectDocumentBuilder(fieldSchemaNode);
                this.addNestedObjectDocumentBuilder(nestedDocumentBuilder);
                return nestedDocumentBuilder;
            }
        }
        LuceneFlattenedObjectDocumentBuilder flattenedDocumentBuilder = new LuceneFlattenedObjectDocumentBuilder(fieldSchemaNode);
        this.addFlattenedObjectDocumentBuilder(flattenedDocumentBuilder);
        return flattenedDocumentBuilder;
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
    }

    private void addNestedObjectDocumentBuilder(LuceneNestedObjectDocumentBuilder nestedObjectDocumentBuilder) {
        if (this.nestedObjectDocumentBuilders == null) {
            this.nestedObjectDocumentBuilders = new ArrayList<LuceneNestedObjectDocumentBuilder>();
        }
        this.nestedObjectDocumentBuilders.add(nestedObjectDocumentBuilder);
    }

    private void addFlattenedObjectDocumentBuilder(LuceneFlattenedObjectDocumentBuilder flattenedObjectDocumentBuilder) {
        if (this.flattenedObjectDocumentBuilders == null) {
            this.flattenedObjectDocumentBuilders = new ArrayList<LuceneFlattenedObjectDocumentBuilder>();
        }
        this.flattenedObjectDocumentBuilders.add(flattenedObjectDocumentBuilder);
    }

    private void checkTreeConsistency(LuceneIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidFieldForDocumentElement(expectedParentNode.getAbsolutePath(), this.schemaNode.getAbsolutePath());
        }
    }

    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, Document currentDocument, List<Document> nestedDocuments) {
        if (this.flattenedObjectDocumentBuilders != null) {
            for (LuceneFlattenedObjectDocumentBuilder flattenedObjectDocumentBuilder : this.flattenedObjectDocumentBuilders) {
                flattenedObjectDocumentBuilder.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, currentDocument, nestedDocuments);
            }
        }
        if (this.nestedObjectDocumentBuilders != null) {
            for (LuceneNestedObjectDocumentBuilder nestedObjectDocumentBuilder : this.nestedObjectDocumentBuilders) {
                nestedObjectDocumentBuilder.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, currentDocument, nestedDocuments);
            }
        }
    }
}

