/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

public class LuceneRootDocumentBuilder
extends AbstractLuceneDocumentBuilder {
    private final Document rootDocument = new Document();

    public LuceneRootDocumentBuilder() {
        super(LuceneIndexSchemaObjectNode.root());
    }

    @Override
    public void addField(IndexableField field) {
        this.rootDocument.add(field);
    }

    public LuceneIndexEntry build(String indexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String id) {
        return new LuceneIndexEntry(indexName, id, this.assembleDocuments(indexName, multiTenancyStrategy, tenantId, id));
    }

    private List<Document> assembleDocuments(String indexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String id) {
        this.rootDocument.add((IndexableField)new StringField(LuceneFields.typeFieldName(), "main", Field.Store.YES));
        this.rootDocument.add((IndexableField)new StringField(LuceneFields.indexFieldName(), indexName, Field.Store.YES));
        this.rootDocument.add((IndexableField)new StringField(LuceneFields.idFieldName(), id, Field.Store.YES));
        multiTenancyStrategy.contributeToIndexedDocument(this.rootDocument, tenantId);
        ArrayList<Document> documents = new ArrayList<Document>();
        this.contribute(indexName, multiTenancyStrategy, tenantId, id, this.rootDocument, documents);
        documents.add(this.rootDocument);
        return documents;
    }
}

