/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactoryContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexSchemaRootNodeBuilder
extends AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaRootNodeBuilder,
IndexSchemaBuildContext {
    private final EventContext indexEventContext;
    private final LuceneIndexFieldTypeFactoryContext typeFactory;
    private ToDocumentIdentifierValueConverter<?> idDslConverter;

    public LuceneIndexSchemaRootNodeBuilder(EventContext indexEventContext, LuceneIndexFieldTypeFactoryContext typeFactory) {
        this.indexEventContext = indexEventContext;
        this.typeFactory = typeFactory;
    }

    public EventContext getEventContext() {
        return this.getIndexEventContext().append(EventContexts.indexSchemaRoot());
    }

    public LuceneIndexFieldTypeFactoryContext getTypeFactory() {
        return this.typeFactory;
    }

    public void explicitRouting() {
        throw new UnsupportedOperationException("explicitRouting not supported right now");
    }

    public void idDslConverter(ToDocumentIdentifierValueConverter<?> idDslConverter) {
        this.idDslConverter = idDslConverter;
    }

    @Override
    public LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this;
    }

    public LuceneIndexModel build(String indexName) {
        final HashMap<String, LuceneIndexSchemaObjectNode> objectNodesBuilder = new HashMap<String, LuceneIndexSchemaObjectNode>();
        final HashMap fieldNodesBuilder = new HashMap();
        final ScopedAnalyzer.Builder scopedAnalyzerBuilder = new ScopedAnalyzer.Builder();
        LuceneIndexSchemaNodeCollector collector = new LuceneIndexSchemaNodeCollector(){

            @Override
            public void collectAnalyzer(String absoluteFieldPath, Analyzer analyzer) {
                scopedAnalyzerBuilder.setAnalyzer(absoluteFieldPath, analyzer);
            }

            @Override
            public void collectFieldNode(String absoluteFieldPath, LuceneIndexSchemaFieldNode<?> node) {
                fieldNodesBuilder.put(absoluteFieldPath, node);
            }

            @Override
            public void collectObjectNode(String absolutePath, LuceneIndexSchemaObjectNode node) {
                objectNodesBuilder.put(absolutePath, node);
            }
        };
        LuceneIndexSchemaObjectNode rootNode = LuceneIndexSchemaObjectNode.root();
        this.contributeChildren(rootNode, collector);
        return new LuceneIndexModel(indexName, (ToDocumentIdentifierValueConverter<?>)(this.idDslConverter == null ? new StringToDocumentIdentifierValueConverter() : this.idDslConverter), (Map<String, LuceneIndexSchemaObjectNode>)objectNodesBuilder, fieldNodesBuilder, scopedAnalyzerBuilder.build());
    }

    @Override
    String getAbsolutePath() {
        return null;
    }

    EventContext getIndexEventContext() {
        return this.indexEventContext;
    }
}

