/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import org.apache.lucene.search.Collector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHitCountCollector;

public class LuceneCollectors {
    private final TopDocsCollector<?> topDocsCollector;
    private final TotalHitCountCollector totalHitCountCollector;
    private final Collector compositeCollector;

    LuceneCollectors(TopDocsCollector<?> topDocsCollector, TotalHitCountCollector totalHitCountCollector, Collector compositeCollector) {
        this.topDocsCollector = topDocsCollector;
        this.totalHitCountCollector = totalHitCountCollector;
        this.compositeCollector = compositeCollector;
    }

    public long getTotalHits() {
        return this.totalHitCountCollector.getTotalHits();
    }

    public TopDocs getTopDocs(long firstResultIndex, Long maxResultsCount) {
        if (this.topDocsCollector == null) {
            return null;
        }
        if (maxResultsCount == null) {
            return this.topDocsCollector.topDocs((int)firstResultIndex);
        }
        return this.topDocsCollector.topDocs((int)firstResultIndex, maxResultsCount.intValue());
    }

    public Collector getCompositeCollector() {
        return this.compositeCollector;
    }
}

