/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanJunctionPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneBooleanJunctionPredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements BooleanJunctionPredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private List<LuceneSearchPredicateBuilder> mustClauseBuilders;
    private List<LuceneSearchPredicateBuilder> mustNotClauseBuilders;
    private List<LuceneSearchPredicateBuilder> shouldClauseBuilders;
    private List<LuceneSearchPredicateBuilder> filterClauseBuilders;
    private NavigableMap<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    LuceneBooleanJunctionPredicateBuilder() {
    }

    public void must(LuceneSearchPredicateBuilder clauseBuilder) {
        if (this.mustClauseBuilders == null) {
            this.mustClauseBuilders = new ArrayList<LuceneSearchPredicateBuilder>();
        }
        this.mustClauseBuilders.add(clauseBuilder);
    }

    public void mustNot(LuceneSearchPredicateBuilder clauseBuilder) {
        if (this.mustNotClauseBuilders == null) {
            this.mustNotClauseBuilders = new ArrayList<LuceneSearchPredicateBuilder>();
        }
        this.mustNotClauseBuilders.add(clauseBuilder);
    }

    public void should(LuceneSearchPredicateBuilder clauseBuilder) {
        if (this.shouldClauseBuilders == null) {
            this.shouldClauseBuilders = new ArrayList<LuceneSearchPredicateBuilder>();
        }
        this.shouldClauseBuilders.add(clauseBuilder);
    }

    public void filter(LuceneSearchPredicateBuilder clauseBuilder) {
        if (this.filterClauseBuilders == null) {
            this.filterClauseBuilders = new ArrayList<LuceneSearchPredicateBuilder>();
        }
        this.filterClauseBuilders.add(clauseBuilder);
    }

    public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(matchingClausesNumber, null));
    }

    public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(null, matchingClausesPercent));
    }

    private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, MinimumShouldMatchConstraint constraint) {
        MinimumShouldMatchConstraint previous;
        if (this.minimumShouldMatchConstraints == null) {
            this.minimumShouldMatchConstraints = new TreeMap<Integer, MinimumShouldMatchConstraint>();
        }
        if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
            throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
        }
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        this.contributeQueries(context, booleanQueryBuilder, this.mustClauseBuilders, BooleanClause.Occur.MUST);
        this.contributeQueries(context, booleanQueryBuilder, this.mustNotClauseBuilders, BooleanClause.Occur.MUST_NOT);
        this.contributeQueries(context, booleanQueryBuilder, this.shouldClauseBuilders, BooleanClause.Occur.SHOULD);
        this.contributeQueries(context, booleanQueryBuilder, this.filterClauseBuilders, BooleanClause.Occur.FILTER);
        if (this.isOnlyMustNot()) {
            booleanQueryBuilder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
        }
        if (this.minimumShouldMatchConstraints != null && this.shouldClauseBuilders != null) {
            Map.Entry<Integer, MinimumShouldMatchConstraint> entry = this.minimumShouldMatchConstraints.lowerEntry(this.shouldClauseBuilders.size());
            int minimumShouldMatch = entry != null ? entry.getValue().toMinimum(this.shouldClauseBuilders.size()) : this.shouldClauseBuilders.size();
            booleanQueryBuilder.setMinimumNumberShouldMatch(minimumShouldMatch);
        }
        return booleanQueryBuilder.build();
    }

    private void contributeQueries(LuceneSearchPredicateContext context, BooleanQuery.Builder booleanQueryBuilder, List<LuceneSearchPredicateBuilder> clauseBuilders, BooleanClause.Occur occur) {
        if (clauseBuilders == null) {
            return;
        }
        for (LuceneSearchPredicateBuilder clauseBuilder : clauseBuilders) {
            booleanQueryBuilder.add(clauseBuilder.build(context), occur);
        }
    }

    private boolean isOnlyMustNot() {
        return !(this.mustNotClauseBuilders == null || this.mustNotClauseBuilders.isEmpty() || this.mustClauseBuilders != null && !this.mustClauseBuilders.isEmpty() || this.shouldClauseBuilders != null && !this.shouldClauseBuilders.isEmpty() || this.filterClauseBuilders != null && !this.filterClauseBuilders.isEmpty());
    }

    private static final class MinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        int toMinimum(int totalShouldClauseNumber) {
            int minimum = this.matchingClausesNumber != null ? (this.matchingClausesNumber >= 0 ? this.matchingClausesNumber : totalShouldClauseNumber + this.matchingClausesNumber) : (this.matchingClausesPercent >= 0 ? this.matchingClausesPercent * totalShouldClauseNumber / 100 : totalShouldClauseNumber + this.matchingClausesPercent * totalShouldClauseNumber / 100);
            if (minimum < 1 || minimum > totalShouldClauseNumber) {
                throw log.minimumShouldMatchMinimumOutOfBounds(minimum, totalShouldClauseNumber);
            }
            return minimum;
        }
    }
}

