/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchScopeModel;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldContext;
import org.hibernate.search.backend.lucene.util.impl.FieldContextSimpleQueryParser;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;

public class LuceneSimpleQueryStringPredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements SimpleQueryStringPredicateBuilder<LuceneSearchPredicateBuilder> {
    private final LuceneSearchScopeModel scopeModel;
    private final Map<String, LuceneSimpleQueryStringPredicateBuilderFieldContext> fields = new LinkedHashMap<String, LuceneSimpleQueryStringPredicateBuilderFieldContext>();
    private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;
    private String simpleQueryString;

    LuceneSimpleQueryStringPredicateBuilder(LuceneSearchScopeModel scopeModel) {
        this.scopeModel = scopeModel;
    }

    public void withAndAsDefaultOperator() {
        this.defaultOperator = BooleanClause.Occur.MUST;
    }

    public SimpleQueryStringPredicateBuilder.FieldContext field(String absoluteFieldPath) {
        LuceneSimpleQueryStringPredicateBuilderFieldContext field = this.fields.get(absoluteFieldPath);
        if (field == null) {
            field = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, LuceneSearchPredicateBuilderFactoryImpl.PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY, DslConverter.DISABLED).createSimpleQueryStringFieldContext(absoluteFieldPath);
            this.fields.put(absoluteFieldPath, field);
        }
        return field;
    }

    public void simpleQueryString(String simpleQueryString) {
        this.simpleQueryString = simpleQueryString;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        Analyzer analyzer = this.buildAnalyzer();
        FieldContextSimpleQueryParser queryParser = new FieldContextSimpleQueryParser(analyzer, this.fields);
        queryParser.setDefaultOperator(this.defaultOperator);
        return queryParser.parse(this.simpleQueryString);
    }

    private Analyzer buildAnalyzer() {
        if (this.fields.size() == 1) {
            return this.fields.values().iterator().next().getAnalyzer();
        }
        ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
        for (Map.Entry<String, LuceneSimpleQueryStringPredicateBuilderFieldContext> entry : this.fields.entrySet()) {
            builder.setAnalyzer(entry.getKey(), entry.getValue().getAnalyzer());
        }
        return builder.build();
    }
}

