/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.search.extraction.impl.DistanceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

class LuceneDistanceToFieldProjection
implements LuceneSearchProjection<Double, Double> {
    private final String absoluteFieldPath;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private DistanceCollector distanceCollector;

    LuceneDistanceToFieldProjection(String absoluteFieldPath, GeoPoint center, DistanceUnit unit) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.center = center;
        this.unit = unit;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        this.distanceCollector = luceneCollectorBuilder.addDistanceCollector(this.absoluteFieldPath, this.center);
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        builder.add(this.absoluteFieldPath);
    }

    @Override
    public Double extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return this.unit.fromMeters(this.distanceCollector.getDistance(documentResult.getDocId()));
    }

    @Override
    public Double transform(LoadingResult<?> loadingResult, Double extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append("]");
        return sb.toString();
    }
}

