/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

class LuceneFieldProjection<F, T>
implements LuceneSearchProjection<F, T> {
    private final String absoluteFieldPath;
    private final LuceneFieldCodec<F> codec;
    private final FromDocumentFieldValueConverter<? super F, T> converter;

    LuceneFieldProjection(String absoluteFieldPath, LuceneFieldCodec<F> codec, FromDocumentFieldValueConverter<? super F, T> converter) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.codec = codec;
        this.converter = converter;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        luceneCollectorBuilder.requireTopDocsCollector();
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        this.codec.contributeStoredFields(this.absoluteFieldPath, builder::add);
    }

    @Override
    public F extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return this.codec.decode(documentResult.getDocument(), this.absoluteFieldPath);
    }

    @Override
    public T transform(LoadingResult<?> loadingResult, F extractedData, SearchProjectionTransformContext context) {
        FromDocumentFieldValueConvertContext convertContext = context.getFromDocumentFieldValueConvertContext();
        return (T)this.converter.convert(extractedData, convertContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append("]");
        return sb.toString();
    }
}

