/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorProvider;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.backend.lucene.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneSearcher<T>
implements AutoCloseable {
    private final Set<String> indexNames;
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final Sort luceneSort;
    private final long offset;
    private final Long limit;
    private final LuceneCollectorProvider luceneCollectorProvider;
    private final LuceneSearchResultExtractor<T> searchResultExtractor;

    public LuceneSearcher(Set<String> indexNames, Set<ReaderProvider> readerProviders, Query luceneQuery, Sort luceneSort, Long offset, Long limit, LuceneCollectorProvider luceneCollectorProvider, LuceneSearchResultExtractor<T> searchResultExtractor) {
        this.indexNames = indexNames;
        this.indexSearcher = new IndexSearcher(MultiReaderFactory.openReader(indexNames, readerProviders));
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
        this.offset = offset == null ? 0L : offset;
        this.limit = limit;
        this.luceneCollectorProvider = luceneCollectorProvider;
        this.searchResultExtractor = searchResultExtractor;
    }

    public LuceneLoadableSearchResult<T> execute() throws IOException {
        LuceneCollectorsBuilder luceneCollectorsBuilder = new LuceneCollectorsBuilder(this.luceneSort, this.getMaxDocs());
        this.luceneCollectorProvider.contributeCollectors(luceneCollectorsBuilder);
        LuceneCollectors luceneCollectors = luceneCollectorsBuilder.build();
        this.indexSearcher.search(this.luceneQuery, luceneCollectors.getCompositeCollector());
        SearchProjectionExtractContext projectionExecutionContext = new SearchProjectionExtractContext(this.indexSearcher, this.luceneQuery);
        return this.searchResultExtractor.extract(this.indexSearcher, luceneCollectors.getTotalHits(), luceneCollectors.getTopDocs(this.offset, this.limit), projectionExecutionContext);
    }

    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexNames(this.indexNames);
    }

    @Override
    public void close() {
        MultiReaderFactory.closeReader(this.indexSearcher.getIndexReader());
    }

    private int getMaxDocs() {
        if (this.limit == null) {
            return this.indexSearcher.getIndexReader().maxDoc();
        }
        if (this.limit == 0L) {
            return 0;
        }
        return Math.min((int)(this.offset + this.limit), this.indexSearcher.getIndexReader().maxDoc());
    }
}

