/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericFieldCodec;

public final class LuceneBooleanFieldCodec
implements LuceneNumericFieldCodec<Boolean, Integer> {
    private final boolean projectable;
    private final boolean sortable;

    public LuceneBooleanFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Boolean value) {
        if (value == null) {
            return;
        }
        Integer intValue = this.encode(value);
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, intValue.intValue()));
        }
        if (this.sortable) {
            documentBuilder.addField((IndexableField)new NumericDocValuesField(absoluteFieldPath, intValue.longValue()));
        }
        documentBuilder.addField((IndexableField)new IntPoint(absoluteFieldPath, new int[]{intValue}));
    }

    @Override
    public Boolean decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        Integer intValue = (Integer)field.numericValue();
        return intValue > 0;
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneBooleanFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneBooleanFieldCodec other = (LuceneBooleanFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    @Override
    public Integer encode(Boolean value) {
        return value != false ? 1 : 0;
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneNumericDomain.INTEGER;
    }
}

