/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.util.function.Consumer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.engine.spatial.GeoPoint;

public final class LuceneGeoPointFieldCodec
implements LuceneFieldCodec<GeoPoint> {
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private final boolean projectable;
    private final boolean sortable;

    public LuceneGeoPointFieldCodec(boolean projectable, boolean sortable) {
        this.projectable = projectable;
        this.sortable = sortable;
    }

    @Override
    public void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, GeoPoint value) {
        if (value == null) {
            return;
        }
        if (this.projectable) {
            documentBuilder.addField((IndexableField)new StoredField(this.getLatitudeAbsoluteFieldPath(absoluteFieldPath), value.getLatitude()));
            documentBuilder.addField((IndexableField)new StoredField(this.getLongitudeAbsoluteFieldPath(absoluteFieldPath), value.getLongitude()));
        }
        documentBuilder.addField((IndexableField)new LatLonDocValuesField(absoluteFieldPath, value.getLatitude(), value.getLongitude()));
        documentBuilder.addField((IndexableField)new LatLonPoint(absoluteFieldPath, value.getLatitude(), value.getLongitude()));
    }

    @Override
    public GeoPoint decode(Document document, String absoluteFieldPath) {
        IndexableField latitudeField = document.getField(this.getLatitudeAbsoluteFieldPath(absoluteFieldPath));
        IndexableField longitudeField = document.getField(this.getLongitudeAbsoluteFieldPath(absoluteFieldPath));
        if (latitudeField == null || longitudeField == null) {
            return null;
        }
        return GeoPoint.of((double)((Double)latitudeField.numericValue()), (double)((Double)longitudeField.numericValue()));
    }

    @Override
    public void contributeStoredFields(String absoluteFieldPath, Consumer<String> collector) {
        collector.accept(this.getLatitudeAbsoluteFieldPath(absoluteFieldPath));
        collector.accept(this.getLongitudeAbsoluteFieldPath(absoluteFieldPath));
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneGeoPointFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneGeoPointFieldCodec other = (LuceneGeoPointFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    private String getLatitudeAbsoluteFieldPath(String absoluteFieldPath) {
        return LuceneFields.internalFieldName(absoluteFieldPath, LATITUDE);
    }

    private String getLongitudeAbsoluteFieldPath(String absoluteFieldPath) {
        return LuceneFields.internalFieldName(absoluteFieldPath, LONGITUDE);
    }
}

