/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.dsl.LuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentFieldValueConverter;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;

abstract class AbstractLuceneStandardIndexFieldTypeContext<S extends AbstractLuceneStandardIndexFieldTypeContext<? extends S, F>, F>
implements LuceneStandardIndexFieldTypeContext<S, F> {
    private final LuceneIndexFieldTypeBuildContext buildContext;
    private final Class<F> fieldType;
    private ToDocumentFieldValueConverter<?, ? extends F> dslToIndexConverter;
    private FromDocumentFieldValueConverter<? super F, ?> indexToProjectionConverter;
    protected Projectable projectable = Projectable.DEFAULT;

    AbstractLuceneStandardIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext, Class<F> fieldType) {
        this.buildContext = buildContext;
        this.fieldType = fieldType;
    }

    public S dslConverter(ToDocumentFieldValueConverter<?, ? extends F> toIndexConverter) {
        Contracts.assertNotNull(toIndexConverter, (String)"toIndexConverter");
        this.dslToIndexConverter = toIndexConverter;
        return this.thisAsS();
    }

    public S projectionConverter(FromDocumentFieldValueConverter<? super F, ?> fromIndexConverter) {
        Contracts.assertNotNull(fromIndexConverter, (String)"fromIndexConverter");
        this.indexToProjectionConverter = fromIndexConverter;
        return this.thisAsS();
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return this.thisAsS();
    }

    public abstract LuceneIndexFieldType<F> toIndexFieldType();

    protected abstract S thisAsS();

    protected final LuceneIndexFieldTypeBuildContext getBuildContext() {
        return this.buildContext;
    }

    protected final ToDocumentFieldValueConverter<?, ? extends F> createDslToIndexConverter() {
        return this.dslToIndexConverter == null ? this.createToDocumentRawConverter() : this.dslToIndexConverter;
    }

    protected final ToDocumentFieldValueConverter<F, ? extends F> createToDocumentRawConverter() {
        return new PassThroughToDocumentFieldValueConverter(this.fieldType);
    }

    protected final FromDocumentFieldValueConverter<? super F, ?> createIndexToProjectionConverter() {
        return this.indexToProjectionConverter == null ? this.createFromDocumentRawConverter() : this.indexToProjectionConverter;
    }

    protected final FromDocumentFieldValueConverter<? super F, F> createFromDocumentRawConverter() {
        return new PassThroughFromDocumentFieldValueConverter(this.fieldType);
    }

    protected static boolean resolveDefault(Projectable projectable) {
        switch (projectable) {
            case DEFAULT: 
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
        }
        throw new AssertionFailure("Unexpected value for Projectable: " + projectable);
    }

    protected static boolean resolveDefault(Sortable sortable) {
        switch (sortable) {
            case DEFAULT: 
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
        }
        throw new AssertionFailure("Unexpected value for Sortable: " + sortable);
    }
}

