/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneByteFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneByteIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneByteIndexFieldTypeContext, Byte> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneByteIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Byte.class);
    }

    public LuceneByteIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Byte> toIndexFieldType() {
        boolean resolvedSortable = LuceneByteIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneByteIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneByteFieldCodec codec = new LuceneByteFieldCodec(resolvedProjectable, resolvedSortable);
        return new LuceneIndexFieldType<Byte>(codec, new LuceneNumericFieldPredicateBuilderFactory<Byte, Integer>((ToDocumentFieldValueConverter<?, Byte>)dslToIndexConverter, (ToDocumentFieldValueConverter<Byte, Byte>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Byte, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Byte>)dslToIndexConverter, (ToDocumentFieldValueConverter<Byte, Byte>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Byte>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneByteIndexFieldTypeContext thisAsS() {
        return this;
    }
}

