/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.LocalDate;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalDateFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneLocalDateIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneLocalDateIndexFieldTypeContext, LocalDate> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneLocalDateIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, LocalDate.class);
    }

    public LuceneLocalDateIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<LocalDate> toIndexFieldType() {
        boolean resolvedSortable = LuceneLocalDateIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneLocalDateIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneLocalDateFieldCodec codec = new LuceneLocalDateFieldCodec(resolvedProjectable, resolvedSortable);
        return new LuceneIndexFieldType<LocalDate>(codec, new LuceneNumericFieldPredicateBuilderFactory<LocalDate, Long>((ToDocumentFieldValueConverter<?, LocalDate>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDate, LocalDate>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<LocalDate, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, LocalDate>)dslToIndexConverter, (ToDocumentFieldValueConverter<LocalDate, LocalDate>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<LocalDate>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneLocalDateIndexFieldTypeContext thisAsS() {
        return this;
    }
}

