/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.LuceneShortFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneShortIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneShortIndexFieldTypeContext, Short> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneShortIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Short.class);
    }

    public LuceneShortIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Short> toIndexFieldType() {
        boolean resolvedSortable = LuceneShortIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneShortIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneShortFieldCodec codec = new LuceneShortFieldCodec(resolvedProjectable, resolvedSortable);
        return new LuceneIndexFieldType<Short>(codec, new LuceneNumericFieldPredicateBuilderFactory<Short, Integer>((ToDocumentFieldValueConverter<?, Short>)dslToIndexConverter, (ToDocumentFieldValueConverter<Short, Short>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Short, Integer>(resolvedSortable, (ToDocumentFieldValueConverter<?, Short>)dslToIndexConverter, (ToDocumentFieldValueConverter<Short, Short>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Short>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneShortIndexFieldTypeContext thisAsS() {
        return this;
    }
}

