/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;

public class LuceneIndexFieldType<F>
implements IndexFieldType<F> {
    private final LuceneFieldCodec<F> codec;
    private final LuceneFieldPredicateBuilderFactory predicateBuilderFactory;
    private final LuceneFieldSortBuilderFactory sortBuilderFactory;
    private final LuceneFieldProjectionBuilderFactory projectionBuilderFactory;
    private final Analyzer analyzerOrNormalizer;

    public LuceneIndexFieldType(LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory) {
        this(codec, predicateBuilderFactory, sortBuilderFactory, projectionBuilderFactory, null);
    }

    public LuceneIndexFieldType(LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory, Analyzer analyzerOrNormalizer) {
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.analyzerOrNormalizer = analyzerOrNormalizer;
    }

    public LuceneIndexSchemaFieldNode<F> addField(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode, String relativeFieldName) {
        LuceneIndexSchemaFieldNode<F> schemaNode = new LuceneIndexSchemaFieldNode<F>(parentNode, relativeFieldName, this.codec, this.predicateBuilderFactory, this.sortBuilderFactory, this.projectionBuilderFactory);
        collector.collectFieldNode(schemaNode.getAbsoluteFieldPath(), schemaNode);
        if (this.analyzerOrNormalizer != null) {
            collector.collectAnalyzer(schemaNode.getAbsoluteFieldPath(), this.analyzerOrNormalizer);
        }
        return schemaNode;
    }
}

