/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.Objects;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.AbstractLuceneStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextMatchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextPhrasePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRangePredicateBuilder;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextWildcardPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

public final class LuceneTextFieldPredicateBuilderFactory<F>
extends AbstractLuceneStandardFieldPredicateBuilderFactory<F, LuceneTextFieldCodec<F>> {
    private final QueryBuilder queryBuilder;

    public LuceneTextFieldPredicateBuilderFactory(ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneTextFieldCodec<F> codec, QueryBuilder queryBuilder) {
        super(converter, rawConverter, codec);
        this.queryBuilder = queryBuilder;
    }

    @Override
    public boolean isDslCompatibleWith(LuceneFieldPredicateBuilderFactory other, DslConverter dslConverter) {
        if (!super.isDslCompatibleWith(other, dslConverter)) {
            return false;
        }
        LuceneTextFieldPredicateBuilderFactory castedOther = (LuceneTextFieldPredicateBuilderFactory)other;
        if (this.queryBuilder == null || castedOther == null) {
            return this.queryBuilder == null && castedOther.queryBuilder == null;
        }
        return Objects.equals(this.queryBuilder.getAnalyzer(), castedOther.queryBuilder.getAnalyzer());
    }

    public LuceneTextMatchPredicateBuilder<?> createMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, DslConverter dslConverter) {
        return new LuceneTextMatchPredicateBuilder(searchContext, absoluteFieldPath, this.getConverter(dslConverter), (LuceneTextFieldCodec)this.codec, this.queryBuilder);
    }

    public LuceneTextRangePredicateBuilder<?> createRangePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, DslConverter dslConverter) {
        return new LuceneTextRangePredicateBuilder(searchContext, absoluteFieldPath, this.getConverter(dslConverter), (LuceneTextFieldCodec)this.codec);
    }

    @Override
    public PhrasePredicateBuilder<LuceneSearchPredicateBuilder> createPhrasePredicateBuilder(String absoluteFieldPath) {
        return new LuceneTextPhrasePredicateBuilder(absoluteFieldPath, (LuceneTextFieldCodec)this.codec, this.queryBuilder);
    }

    @Override
    public WildcardPredicateBuilder<LuceneSearchPredicateBuilder> createWildcardPredicateBuilder(String absoluteFieldPath) {
        return new LuceneTextWildcardPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public LuceneSimpleQueryStringPredicateBuilderFieldContext createSimpleQueryStringFieldContext(String absoluteFieldPath) {
        return new LuceneSimpleQueryStringPredicateBuilderFieldContext(this.queryBuilder == null ? null : this.queryBuilder.getAnalyzer());
    }
}

