/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneStandardMatchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.util.impl.FuzzyQueryBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneTextMatchPredicateBuilder<F>
extends AbstractLuceneStandardMatchPredicateBuilder<F, String, LuceneTextFieldCodec<F>> {
    private final QueryBuilder queryBuilder;
    private Integer maxEditDistance;
    private Integer prefixLength;

    LuceneTextMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, LuceneTextFieldCodec<F> codec, QueryBuilder queryBuilder) {
        super(searchContext, absoluteFieldPath, converter, codec);
        this.queryBuilder = queryBuilder;
    }

    @Override
    public void fuzzy(int maxEditDistance, int exactPrefixLength) {
        this.maxEditDistance = maxEditDistance;
        this.prefixLength = exactPrefixLength;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (this.queryBuilder != null) {
            QueryBuilder effectiveQueryBuilder = this.maxEditDistance != null ? new FuzzyQueryBuilder(this.queryBuilder.getAnalyzer(), this.maxEditDistance, this.prefixLength) : this.queryBuilder;
            Query analyzed = effectiveQueryBuilder.createBooleanQuery(this.absoluteFieldPath, (String)this.value);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the value to match");
            }
            return analyzed;
        }
        Term term = new Term(this.absoluteFieldPath, ((LuceneTextFieldCodec)this.codec).normalize(this.absoluteFieldPath, (String)this.value));
        if (this.maxEditDistance != null) {
            return new FuzzyQuery(term, this.maxEditDistance.intValue(), this.prefixLength.intValue());
        }
        return new TermQuery(term);
    }
}

