/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWorkExecutionContext;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneDeleteEntryWork
extends AbstractLuceneWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;
    private final String id;

    public AbstractLuceneDeleteEntryWork(String indexName, String tenantId, String id) {
        super("deleteEntry", indexName);
        this.tenantId = tenantId;
        this.id = id;
    }

    @Override
    public CompletableFuture<Long> execute(LuceneIndexWorkExecutionContext context) {
        return Futures.create(() -> CompletableFuture.completedFuture(this.deleteDocuments(context.getIndexWriter())));
    }

    private Long deleteDocuments(IndexWriter indexWriter) {
        try {
            return this.doDeleteDocuments(indexWriter, this.tenantId, this.id);
        }
        catch (IOException e) {
            throw log.unableToDeleteEntryFromIndex(this.tenantId, this.id, this.getEventContext(), e);
        }
    }

    protected abstract long doDeleteDocuments(IndexWriter var1, String var2, String var3) throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", indexName=").append(this.indexName).append(", id=").append(this.id).append("]");
        return sb.toString();
    }
}

