/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneAddEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneCommitIndexWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneExecuteQueryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneFlushIndexWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneOptimizeIndexWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;

public class LuceneStubWorkFactory
implements LuceneWorkFactory {
    private final MultiTenancyStrategy multiTenancyStrategy;

    public LuceneStubWorkFactory(MultiTenancyStrategy multiTenancyStrategy) {
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    @Override
    public LuceneIndexWork<?> add(String indexName, String tenantId, String id, String routingKey, LuceneIndexEntry indexEntry) {
        return new LuceneAddEntryWork(indexName, tenantId, id, indexEntry);
    }

    @Override
    public LuceneIndexWork<?> update(String indexName, String tenantId, String id, String routingKey, LuceneIndexEntry indexEntry) {
        return this.multiTenancyStrategy.createUpdateEntryLuceneWork(indexName, tenantId, id, indexEntry);
    }

    @Override
    public LuceneIndexWork<?> delete(String indexName, String tenantId, String id, String routingKey) {
        return this.multiTenancyStrategy.createDeleteEntryLuceneWork(indexName, tenantId, id);
    }

    @Override
    public LuceneIndexWork<?> deleteAll(String indexName, String tenantId) {
        return this.multiTenancyStrategy.createDeleteAllEntriesLuceneWork(indexName, tenantId);
    }

    @Override
    public LuceneIndexWork<?> flush(String indexName) {
        return new LuceneFlushIndexWork(indexName);
    }

    @Override
    public LuceneIndexWork<?> commit(String indexName) {
        return new LuceneCommitIndexWork(indexName);
    }

    @Override
    public LuceneIndexWork<?> optimize(String indexName) {
        return new LuceneOptimizeIndexWork(indexName);
    }

    @Override
    public <T> LuceneExecuteQueryWork<T> search(LuceneSearcher<T> luceneSearcher) {
        return new LuceneExecuteQueryWork<T>(luceneSearcher);
    }
}

