/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

class LuceneNestedObjectDocumentBuilder
extends AbstractLuceneDocumentBuilder {
    private final Document nestedDocument = new Document();
    private final Set<String> fieldNames = new HashSet<String>();

    LuceneNestedObjectDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        super(schemaNode);
    }

    @Override
    public void addField(IndexableField field) {
        this.nestedDocument.add(field);
    }

    @Override
    public void addFieldName(String absoluteFieldPath) {
        this.fieldNames.add(absoluteFieldPath);
    }

    @Override
    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, Document currentDocument, List<Document> nestedDocuments) {
        this.nestedDocument.add((IndexableField)new StringField(LuceneFields.typeFieldName(), "child", Field.Store.YES));
        this.nestedDocument.add((IndexableField)new StringField(LuceneFields.rootIndexFieldName(), rootIndexName, Field.Store.YES));
        this.nestedDocument.add((IndexableField)new StringField(LuceneFields.rootIdFieldName(), rootId, Field.Store.YES));
        this.nestedDocument.add((IndexableField)new StringField(LuceneFields.nestedDocumentPathFieldName(), this.schemaNode.getAbsolutePath(), Field.Store.YES));
        for (String fieldName : this.fieldNames) {
            this.nestedDocument.add((IndexableField)new StringField(LuceneFields.fieldNamesFieldName(), fieldName, Field.Store.NO));
        }
        multiTenancyStrategy.contributeToIndexedDocument(this.nestedDocument, tenantId);
        super.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, this.nestedDocument, nestedDocuments);
        nestedDocuments.add(this.nestedDocument);
    }
}

