/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexSchemaFieldNode<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String relativeFieldName;
    private final LuceneIndexSchemaObjectNode parent;
    private final String absoluteFieldPath;
    private final LuceneFieldCodec<F> codec;
    private final LuceneFieldPredicateBuilderFactory predicateBuilderFactory;
    private final LuceneFieldSortBuilderFactory sortBuilderFactory;
    private final LuceneFieldProjectionBuilderFactory projectionBuilderFactory;

    public LuceneIndexSchemaFieldNode(LuceneIndexSchemaObjectNode parent, String relativeFieldName, LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = parent.getAbsolutePath(relativeFieldName);
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
    }

    public LuceneIndexSchemaObjectNode getParent() {
        return this.parent;
    }

    public String getAbsoluteFieldPath() {
        return this.absoluteFieldPath;
    }

    public LuceneFieldPredicateBuilderFactory getPredicateBuilderFactory() {
        if (this.predicateBuilderFactory == null) {
            throw log.unsupportedDSLPredicates(this.getEventContext());
        }
        return this.predicateBuilderFactory;
    }

    public LuceneFieldSortBuilderFactory getSortBuilderFactory() {
        if (this.sortBuilderFactory == null) {
            throw log.unsupportedDSLSorts(this.getEventContext());
        }
        return this.sortBuilderFactory;
    }

    public LuceneFieldProjectionBuilderFactory getProjectionBuilderFactory() {
        if (this.projectionBuilderFactory == null) {
            throw log.unsupportedDSLProjections(this.getEventContext());
        }
        return this.projectionBuilderFactory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("parent=").append(this.parent).append(", relativeFieldName=").append(this.relativeFieldName).append(", codec=").append(this.codec).append(", predicateBuilderFactory=").append(this.predicateBuilderFactory).append(", sortContributor=").append(this.sortBuilderFactory).append(", projectionBuilderFactory=").append(this.projectionBuilderFactory).append("]");
        return sb.toString();
    }

    private EventContext getEventContext() {
        return EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath);
    }

    public LuceneFieldCodec<F> getCodec() {
        return this.codec;
    }
}

