/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.InitialLuceneAnalysisDefinitionContainerContext;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.cfg.LuceneBackendSettings;
import org.hibernate.search.backend.lucene.cfg.MultiTenancyStrategyName;
import org.hibernate.search.backend.lucene.impl.LuceneBackendImpl;
import org.hibernate.search.backend.lucene.impl.MMapDirectoryProvider;
import org.hibernate.search.backend.lucene.index.impl.DirectoryProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.LuceneStubWorkFactory;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Optional<Version>> LUCENE_VERSION = ConfigurationProperty.forKey((String)"lucene_version").as(Version.class, LuceneBackendFactory::parseLuceneVersion).build();
    private static final OptionalConfigurationProperty<String> DIRECTORY_PROVIDER = ConfigurationProperty.forKey((String)"directory_provider").asString().build();
    private static final ConfigurationProperty<Path> ROOT_DIRECTORY = ConfigurationProperty.forKey((String)"root_directory").as(Path.class, x$0 -> Paths.get(x$0, new String[0])).withDefault(() -> Paths.get(".", new String[0])).build();
    private static final ConfigurationProperty<MultiTenancyStrategyName> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy_strategy").as(MultiTenancyStrategyName.class, MultiTenancyStrategyName::of).withDefault((Object)LuceneBackendSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends LuceneAnalysisConfigurer>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis_configurer").asBeanReference(LuceneAnalysisConfigurer.class).build();

    public BackendImplementor<?> create(String name, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        EventContext backendContext = EventContexts.fromBackendName((String)name);
        Version luceneVersion = this.getLuceneVersion(backendContext, propertySource);
        DirectoryProvider directoryProvider = this.getDirectoryProvider(backendContext, propertySource);
        MultiTenancyStrategy multiTenancyStrategy = this.getMultiTenancyStrategy(backendContext, propertySource);
        LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry = this.getAnalysisDefinitionRegistry(backendContext, buildContext, propertySource, luceneVersion);
        return new LuceneBackendImpl(name, directoryProvider, new LuceneStubWorkFactory(multiTenancyStrategy), analysisDefinitionRegistry, multiTenancyStrategy);
    }

    private Version getLuceneVersion(EventContext backendContext, ConfigurationPropertySource propertySource) {
        Version luceneVersion;
        Optional luceneVersionOptional = (Optional)LUCENE_VERSION.get(propertySource);
        if (luceneVersionOptional.isPresent()) {
            luceneVersion = (Version)luceneVersionOptional.get();
            if (log.isDebugEnabled()) {
                log.debug("Setting Lucene compatibility to Version " + luceneVersion);
            }
        } else {
            Version latestVersion = LuceneBackendSettings.Defaults.LUCENE_VERSION;
            log.recommendConfiguringLuceneVersion(LUCENE_VERSION.resolveOrRaw(propertySource), latestVersion, backendContext);
            luceneVersion = latestVersion;
        }
        return luceneVersion;
    }

    private DirectoryProvider getDirectoryProvider(EventContext backendContext, ConfigurationPropertySource propertySource) {
        String directoryProviderString = (String)DIRECTORY_PROVIDER.getOrThrow(propertySource, propertyKey -> log.undefinedLuceneDirectoryProvider((String)propertyKey, backendContext));
        if ("local_directory".equals(directoryProviderString)) {
            Path rootDirectory = ((Path)ROOT_DIRECTORY.get(propertySource)).toAbsolutePath();
            this.initializeRootDirectory(rootDirectory, backendContext);
            return new MMapDirectoryProvider(backendContext, rootDirectory);
        }
        throw log.unrecognizedLuceneDirectoryProvider(directoryProviderString, backendContext);
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(EventContext backendContext, ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyName multiTenancyStrategyName = (MultiTenancyStrategyName)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyName) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%1$s'. %2$s", new Object[]{multiTenancyStrategyName, backendContext.render()}));
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry(EventContext backendContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource, Version luceneVersion) {
        try {
            BeanProvider beanProvider = buildContext.getBeanProvider();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanProvider)beanProvider).getBean(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    LuceneAnalysisComponentFactory analysisComponentFactory = new LuceneAnalysisComponentFactory(luceneVersion, buildContext.getClassResolver(), buildContext.getResourceResolver());
                    InitialLuceneAnalysisDefinitionContainerContext collector = new InitialLuceneAnalysisDefinitionContainerContext(analysisComponentFactory);
                    ((LuceneAnalysisConfigurer)configurerHolder.get()).configure(collector);
                    LuceneAnalysisDefinitionRegistry luceneAnalysisDefinitionRegistry = new LuceneAnalysisDefinitionRegistry(collector);
                    return luceneAnalysisDefinitionRegistry;
                }
            }).orElseGet(LuceneAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), backendContext, e);
        }
    }

    private void initializeRootDirectory(Path rootDirectory, EventContext eventContext) {
        if (Files.exists(rootDirectory, new LinkOption[0])) {
            if (!Files.isDirectory(rootDirectory, new LinkOption[0]) || !Files.isWritable(rootDirectory)) {
                throw log.localDirectoryBackendRootDirectoryNotWritableDirectory(rootDirectory, eventContext);
            }
        } else {
            try {
                Files.createDirectories(rootDirectory, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw log.unableToCreateRootDirectoryForLocalDirectoryBackend(rootDirectory, eventContext, e);
            }
        }
    }

    private static Version parseLuceneVersion(String versionString) {
        try {
            return Version.parseLeniently((String)versionString);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw log.illegalLuceneVersionFormat(versionString, e.getMessage(), e);
        }
    }
}

