/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.index.spi.DocumentContributor;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

class LuceneIndexDocumentWorkExecutor
implements IndexDocumentWorkExecutor<LuceneRootDocumentBuilder> {
    private final LuceneWorkFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneIndexWorkOrchestrator orchestrator;
    private final String indexName;
    private final String tenantId;

    LuceneIndexDocumentWorkExecutor(LuceneWorkFactory factory, MultiTenancyStrategy multiTenancyStrategy, LuceneIndexWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder();
        documentContributor.contribute((Object)builder);
        LuceneIndexEntry indexEntry = builder.build(this.indexName, this.multiTenancyStrategy, this.tenantId, id);
        ArrayList works = new ArrayList();
        works.add(this.factory.add(this.indexName, this.tenantId, id, routingKey, indexEntry));
        works.add(this.factory.commit(this.indexName));
        return this.orchestrator.submit(works);
    }
}

