/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneIndexWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneIndexWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.index.spi.DocumentContributor;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

class LuceneIndexWorkPlan
implements IndexWorkPlan<LuceneRootDocumentBuilder> {
    private final LuceneWorkFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneIndexWorkOrchestrator orchestrator;
    private final String indexName;
    private final String tenantId;
    private final List<LuceneIndexWork<?>> works = new ArrayList();

    LuceneIndexWorkPlan(LuceneWorkFactory factory, MultiTenancyStrategy multiTenancyStrategy, LuceneIndexWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder();
        documentContributor.contribute((Object)builder);
        LuceneIndexEntry indexEntry = builder.build(this.indexName, this.multiTenancyStrategy, this.tenantId, id);
        this.collect(this.factory.add(this.indexName, this.tenantId, id, routingKey, indexEntry));
        this.collect(this.factory.commit(this.indexName));
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder();
        documentContributor.contribute((Object)builder);
        LuceneIndexEntry indexEntry = builder.build(this.indexName, this.multiTenancyStrategy, this.tenantId, id);
        this.collect(this.factory.update(this.indexName, this.tenantId, id, routingKey, indexEntry));
        this.collect(this.factory.commit(this.indexName));
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        this.collect(this.factory.delete(this.indexName, this.tenantId, id, routingKey));
        this.collect(this.factory.commit(this.indexName));
    }

    public void prepare() {
    }

    public CompletableFuture<?> execute() {
        try {
            CompletableFuture<?> completableFuture = this.orchestrator.submit(this.works);
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    private void collect(LuceneIndexWork<?> work) {
        this.works.add(work);
    }
}

