/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneQueryWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneStubQueryWorkExecutionContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneQueryWork;
import org.hibernate.search.util.common.impl.Futures;

public class LuceneStubQueryWorkOrchestrator
implements LuceneQueryWorkOrchestrator {
    private final LuceneStubQueryWorkExecutionContext context;
    private CompletableFuture<?> latestFuture = CompletableFuture.completedFuture(null);

    public LuceneStubQueryWorkOrchestrator() {
        this.context = new LuceneStubQueryWorkExecutionContext();
    }

    @Override
    public void close() {
        this.latestFuture.join();
    }

    @Override
    public synchronized <T> CompletableFuture<T> submit(LuceneQueryWork<T> work) {
        CompletionStage future = this.latestFuture.thenCompose(Futures.safeComposer(ignored -> work.execute(this.context)));
        this.latestFuture = ((CompletableFuture)future).exceptionally(ignore -> null);
        return future;
    }

    @Override
    public synchronized CompletableFuture<?> submit(List<LuceneQueryWork<?>> works) {
        CompletionStage<Object> future = this.latestFuture;
        for (LuceneQueryWork<?> work : works) {
            future = future.thenCompose(Futures.safeComposer(ignored -> work.execute(this.context)));
        }
        this.latestFuture = future.exceptionally(ignore -> null);
        return future;
    }
}

