/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TotalHitCountCollector;

public class LuceneCollectors {
    private final TopDocsCollector<?> topDocsCollector;
    private final TotalHitCountCollector totalHitCountCollector;
    private final Collector compositeCollector;
    private final boolean requireFieldDocRescoring;
    private final Integer scoreSortFieldIndexForRescoring;
    private TopDocs topDocs = null;

    LuceneCollectors(TopDocsCollector<?> topDocsCollector, TotalHitCountCollector totalHitCountCollector, Collector compositeCollector, boolean requireFieldDocRescoring, Integer scoreSortFieldIndexForRescoring) {
        this.topDocsCollector = topDocsCollector;
        this.totalHitCountCollector = totalHitCountCollector;
        this.compositeCollector = compositeCollector;
        this.requireFieldDocRescoring = requireFieldDocRescoring;
        this.scoreSortFieldIndexForRescoring = scoreSortFieldIndexForRescoring;
    }

    public void collect(IndexSearcher indexSearcher, Query luceneQuery, long offset, Long limit) throws IOException {
        indexSearcher.search(luceneQuery, this.compositeCollector);
        if (this.topDocsCollector != null) {
            this.topDocs = limit == null ? this.topDocsCollector.topDocs((int)offset) : this.topDocsCollector.topDocs((int)offset, limit.intValue());
            if (this.requireFieldDocRescoring) {
                if (this.scoreSortFieldIndexForRescoring != null) {
                    for (ScoreDoc scoreDoc : this.topDocs.scoreDocs) {
                        FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                        fieldDoc.score = ((Float)fieldDoc.fields[this.scoreSortFieldIndexForRescoring]).floatValue();
                    }
                } else {
                    TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)indexSearcher, (Query)luceneQuery);
                }
            }
        } else {
            this.topDocs = null;
        }
    }

    public long getTotalHits() {
        return this.totalHitCountCollector.getTotalHits();
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }
}

