/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.DistanceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneCollectorsBuilder {
    private final Sort sort;
    private final int maxDocs;
    private final TotalHitCountCollector totalHitCountCollector;
    private boolean requireTopDocs;
    private boolean requireScore;
    private final List<Collector> luceneCollectors = new ArrayList<Collector>();

    public LuceneCollectorsBuilder(Sort sort, int maxDocs) {
        this.sort = sort;
        this.maxDocs = maxDocs;
        this.totalHitCountCollector = new TotalHitCountCollector();
        this.luceneCollectors.add((Collector)this.totalHitCountCollector);
    }

    public void requireScore() {
        this.requireTopDocs = true;
        this.requireScore = true;
    }

    public void requireTopDocsCollector() {
        this.requireTopDocs = true;
    }

    public DistanceCollector addDistanceCollector(String absoluteFieldPath, GeoPoint center) {
        DistanceCollector distanceCollector = new DistanceCollector(absoluteFieldPath, center, this.maxDocs);
        this.luceneCollectors.add(distanceCollector);
        return distanceCollector;
    }

    public LuceneCollectors build() {
        TopScoreDocCollector topDocsCollector = null;
        Integer scoreSortFieldIndexForRescoring = null;
        boolean requireFieldDocRescoring = false;
        if (this.requireTopDocs && this.maxDocs > 0) {
            if (this.sort == null) {
                topDocsCollector = TopScoreDocCollector.create((int)this.maxDocs, (int)Integer.MAX_VALUE);
            } else {
                if (this.requireScore) {
                    requireFieldDocRescoring = true;
                    SortField[] sortFields = this.sort.getSort();
                    for (int i = 0; i < sortFields.length; ++i) {
                        SortField sortField = sortFields[i];
                        if (sortField.getType() != SortField.Type.SCORE) continue;
                        scoreSortFieldIndexForRescoring = i;
                        break;
                    }
                }
                topDocsCollector = TopFieldCollector.create((Sort)this.sort, (int)this.maxDocs, (int)Integer.MAX_VALUE);
            }
            this.luceneCollectors.add((Collector)topDocsCollector);
        }
        Collector compositeCollector = this.luceneCollectors.size() == 1 ? this.luceneCollectors.get(0) : MultiCollector.wrap(this.luceneCollectors);
        return new LuceneCollectors((TopDocsCollector<?>)topDocsCollector, this.totalHitCountCollector, compositeCollector, requireFieldDocRescoring, scoreSortFieldIndexForRescoring);
    }
}

