/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchResultExtractor;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

class LuceneSearchResultExtractorImpl<T>
implements LuceneSearchResultExtractor<T> {
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private final LuceneSearchProjection<?, T> rootProjection;
    private final ProjectionHitMapper<?, ?> projectionHitMapper;

    LuceneSearchResultExtractorImpl(ReusableDocumentStoredFieldVisitor storedFieldVisitor, LuceneSearchProjection<?, T> rootProjection, ProjectionHitMapper<?, ?> projectionHitMapper) {
        this.storedFieldVisitor = storedFieldVisitor;
        this.rootProjection = rootProjection;
        this.projectionHitMapper = projectionHitMapper;
    }

    @Override
    public LuceneLoadableSearchResult<T> extract(IndexSearcher indexSearcher, long totalHits, TopDocs topDocs, SearchProjectionExtractContext projectionExecutionContext) throws IOException {
        List<Object> extractedData = this.extractHits(indexSearcher, topDocs, projectionExecutionContext);
        return new LuceneLoadableSearchResult<T>(this.projectionHitMapper, this.rootProjection, totalHits, extractedData);
    }

    private List<Object> extractHits(IndexSearcher indexSearcher, TopDocs topDocs, SearchProjectionExtractContext projectionExecutionContext) throws IOException {
        if (topDocs == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> extractedData = new ArrayList<Object>(topDocs.scoreDocs.length);
        for (ScoreDoc hit : topDocs.scoreDocs) {
            indexSearcher.doc(hit.doc, (StoredFieldVisitor)this.storedFieldVisitor);
            Document document = this.storedFieldVisitor.getDocumentAndReset();
            LuceneResult luceneResult = new LuceneResult(document, hit.doc, hit.score);
            extractedData.add(this.rootProjection.extract(this.projectionHitMapper, luceneResult, projectionExecutionContext));
        }
        return extractedData;
    }
}

