/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalDateTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;

public final class LuceneOffsetDateTimeFieldCodec
extends AbstractLuceneNumericFieldCodec<OffsetDateTime, Long> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(LuceneLocalDateTimeFieldCodec.FORMATTER).appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneOffsetDateTimeFieldCodec(boolean projectable, boolean sortable, OffsetDateTime indexNullAsValue) {
        super(projectable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, OffsetDateTime value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public OffsetDateTime decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return OffsetDateTime.parse(value, FORMATTER);
    }

    @Override
    public Long encode(OffsetDateTime value) {
        return value == null ? null : Long.valueOf(value.toInstant().toEpochMilli());
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

