/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneLocalTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;

public final class LuceneOffsetTimeFieldCodec
extends AbstractLuceneNumericFieldCodec<OffsetTime, Long> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(LuceneLocalTimeFieldCodec.FORMATTER).appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneOffsetTimeFieldCodec(boolean projectable, boolean sortable, OffsetTime indexNullAsValue) {
        super(projectable, sortable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, OffsetTime value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public OffsetTime decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return OffsetTime.parse(value, FORMATTER);
    }

    @Override
    public Long encode(OffsetTime value) {
        if (value == null) {
            return null;
        }
        long nod = value.toLocalTime().toNanoOfDay();
        long offsetNanos = (long)value.getOffset().getTotalSeconds() * 1000000000L;
        return nod - offsetNanos;
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneNumericDomain.LONG;
    }
}

