/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldContributor;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldValueExtractor;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactoryContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneBooleanIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneByteIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneDoubleIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneFieldIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneFloatIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneGeoPointIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneInstantIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIntegerIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalDateIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalDateTimeIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalTimeIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLongIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneMonthDayIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneOffsetDateTimeIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneOffsetTimeIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneShortIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneStringIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneYearIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneYearMonthIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneZonedDateTimeIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeTerminalContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexFieldTypeFactoryContextImpl
implements LuceneIndexFieldTypeFactoryContext,
LuceneIndexFieldTypeBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;

    public LuceneIndexFieldTypeFactoryContextImpl(EventContext eventContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.eventContext = eventContext;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public <F> StandardIndexFieldTypeContext<?, F> as(Class<F> inputType) {
        if (String.class.equals(inputType)) {
            return this.asString();
        }
        if (Integer.class.equals(inputType)) {
            return this.asInteger();
        }
        if (Long.class.equals(inputType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(inputType)) {
            return this.asBoolean();
        }
        if (Byte.class.equals(inputType)) {
            return this.asByte();
        }
        if (Short.class.equals(inputType)) {
            return this.asShort();
        }
        if (Float.class.equals(inputType)) {
            return this.asFloat();
        }
        if (Double.class.equals(inputType)) {
            return this.asDouble();
        }
        if (LocalDate.class.equals(inputType)) {
            return this.asLocalDate();
        }
        if (LocalDateTime.class.equals(inputType)) {
            return this.asLocalDateTime();
        }
        if (LocalTime.class.equals(inputType)) {
            return this.asLocalTime();
        }
        if (Instant.class.equals(inputType)) {
            return this.asInstant();
        }
        if (ZonedDateTime.class.equals(inputType)) {
            return this.asZonedDateTime();
        }
        if (Year.class.equals(inputType)) {
            return this.asYear();
        }
        if (YearMonth.class.equals(inputType)) {
            return this.asYearMonth();
        }
        if (MonthDay.class.equals(inputType)) {
            return this.asMonthDay();
        }
        if (OffsetDateTime.class.equals(inputType)) {
            return this.asOffsetDateTime();
        }
        if (OffsetTime.class.equals(inputType)) {
            return this.asOffsetTime();
        }
        if (GeoPoint.class.equals(inputType)) {
            return this.asGeoPoint();
        }
        throw log.cannotGuessFieldType(inputType, this.getEventContext());
    }

    public StringIndexFieldTypeContext<?> asString() {
        return new LuceneStringIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Integer> asInteger() {
        return new LuceneIntegerIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Long> asLong() {
        return new LuceneLongIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Boolean> asBoolean() {
        return new LuceneBooleanIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Byte> asByte() {
        return new LuceneByteIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Short> asShort() {
        return new LuceneShortIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Float> asFloat() {
        return new LuceneFloatIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Double> asDouble() {
        return new LuceneDoubleIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalDate> asLocalDate() {
        return new LuceneLocalDateIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalDateTime> asLocalDateTime() {
        return new LuceneLocalDateTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, LocalTime> asLocalTime() {
        return new LuceneLocalTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Instant> asInstant() {
        return new LuceneInstantIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, ZonedDateTime> asZonedDateTime() {
        return new LuceneZonedDateTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, Year> asYear() {
        return new LuceneYearIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, YearMonth> asYearMonth() {
        return new LuceneYearMonthIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, MonthDay> asMonthDay() {
        return new LuceneMonthDayIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, OffsetDateTime> asOffsetDateTime() {
        return new LuceneOffsetDateTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, OffsetTime> asOffsetTime() {
        return new LuceneOffsetTimeIndexFieldTypeContext(this);
    }

    public StandardIndexFieldTypeContext<?, GeoPoint> asGeoPoint() {
        return new LuceneGeoPointIndexFieldTypeContext(this);
    }

    @Override
    public <F> IndexFieldTypeTerminalContext<F> asNative(Class<F> indexFieldType, LuceneFieldContributor<F> fieldContributor, LuceneFieldValueExtractor<F> fieldValueExtractor) {
        return new LuceneFieldIndexFieldTypeContext<F>(indexFieldType, fieldContributor, fieldValueExtractor);
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }
}

