/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneStandardFieldSortBuilderFactory<F, C extends LuceneStandardFieldCodec<F, ?>>
implements LuceneFieldSortBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean sortable;
    protected final ToDocumentFieldValueConverter<?, ? extends F> converter;
    protected final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    protected final C codec;

    protected AbstractLuceneStandardFieldSortBuilderFactory(boolean sortable, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, C codec) {
        this.sortable = sortable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    @Override
    public DistanceSortBuilder<LuceneSearchSortBuilder> createDistanceSortBuilder(String absoluteFieldPath, GeoPoint center) {
        throw log.distanceOperationsNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public boolean hasCompatibleCodec(LuceneFieldSortBuilderFactory other) {
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        AbstractLuceneStandardFieldSortBuilderFactory otherFactory = (AbstractLuceneStandardFieldSortBuilderFactory)other;
        return this.sortable == otherFactory.sortable && this.codec.isCompatibleWith((LuceneFieldCodec<?>)otherFactory.codec);
    }

    @Override
    public boolean hasCompatibleConverter(LuceneFieldSortBuilderFactory other) {
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        AbstractLuceneStandardFieldSortBuilderFactory otherFactory = (AbstractLuceneStandardFieldSortBuilderFactory)other;
        return this.converter.isCompatibleWith(otherFactory.converter);
    }

    protected void checkSortable(String absoluteFieldPath) {
        if (!this.sortable) {
            throw log.unsortableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

