/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;

class LuceneTextWildcardPredicateBuilder extends AbstractLuceneSearchPredicateBuilder
		implements WildcardPredicateBuilder<LuceneSearchPredicateBuilder> {

	protected final String absoluteFieldPath;

	private String pattern;

	LuceneTextWildcardPredicateBuilder(String absoluteFieldPath) {
		this.absoluteFieldPath = absoluteFieldPath;
	}

	@Override
	public void pattern(String wildcardPattern) {
		this.pattern = wildcardPattern;
	}

	@Override
	protected Query doBuild(LuceneSearchPredicateContext context) {
		return new WildcardQuery( new Term( absoluteFieldPath, pattern ) );
	}
}
