/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalyzerDefinitionWithTokenizerContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneCustomAnalyzerDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.DelegatingAnalysisDefinitionContainerContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.InitialLuceneAnalysisDefinitionContainerContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneCharFilterDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenFilterDefinitionContext;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenizerDefinitionContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneCustomAnalyzerDefinitionContextImpl
extends DelegatingAnalysisDefinitionContainerContext
implements LuceneCustomAnalyzerDefinitionContext,
LuceneAnalyzerDefinitionWithTokenizerContext,
LuceneAnalyzerBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final LuceneTokenizerDefinitionContext tokenizer;
    private final List<LuceneCharFilterDefinitionContext> charFilters = new ArrayList<LuceneCharFilterDefinitionContext>();
    private final List<LuceneTokenFilterDefinitionContext> tokenFilters = new ArrayList<LuceneTokenFilterDefinitionContext>();

    LuceneCustomAnalyzerDefinitionContextImpl(InitialLuceneAnalysisDefinitionContainerContext parentContext, String name) {
        super(parentContext);
        this.tokenizer = new LuceneTokenizerDefinitionContext(this);
        this.name = name;
    }

    @Override
    public LuceneAnalyzerDefinitionWithTokenizerContext tokenizer(Class<? extends TokenizerFactory> factory) {
        this.tokenizer.factory(factory);
        return this;
    }

    @Override
    public LuceneAnalyzerDefinitionWithTokenizerContext param(String name, String value) {
        this.tokenizer.param(name, value);
        return this;
    }

    @Override
    public LuceneAnalysisComponentDefinitionContext charFilter(Class<? extends CharFilterFactory> factory) {
        LuceneCharFilterDefinitionContext filter = new LuceneCharFilterDefinitionContext(this, factory);
        this.charFilters.add(filter);
        return filter;
    }

    @Override
    public LuceneAnalysisComponentDefinitionContext tokenFilter(Class<? extends TokenFilterFactory> factory) {
        LuceneTokenFilterDefinitionContext filter = new LuceneTokenFilterDefinitionContext(this, factory);
        this.tokenFilters.add(filter);
        return filter;
    }

    @Override
    public Analyzer build(LuceneAnalysisComponentFactory factory) {
        try {
            return factory.createAnalyzer(this.tokenizer.build(factory), (CharFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.charFilters, CharFilterFactory[]::new, factory), (TokenFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.tokenFilters, TokenFilterFactory[]::new, factory));
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCreateAnalyzer(this.name, e);
        }
    }
}

