/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneNonFlattenedDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

class LuceneNestedObjectDocumentBuilder
extends AbstractLuceneNonFlattenedDocumentBuilder {
    LuceneNestedObjectDocumentBuilder(LuceneIndexSchemaObjectNode schemaNode) {
        super(schemaNode);
    }

    @Override
    void contribute(String rootIndexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String rootId, Document currentDocument, List<Document> nestedDocuments) {
        this.document.add((IndexableField)new StringField(LuceneFields.typeFieldName(), "child", Field.Store.YES));
        this.document.add((IndexableField)new StringField(LuceneFields.rootIndexFieldName(), rootIndexName, Field.Store.YES));
        this.document.add((IndexableField)new StringField(LuceneFields.rootIdFieldName(), rootId, Field.Store.YES));
        this.document.add((IndexableField)new StringField(LuceneFields.nestedDocumentPathFieldName(), this.schemaNode.getAbsolutePath(), Field.Store.YES));
        super.contribute(rootIndexName, multiTenancyStrategy, tenantId, rootId, this.document, nestedDocuments);
        nestedDocuments.add(this.document);
    }
}

