/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexSchemaObjectFieldNodeBuilder
extends AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectFieldNodeBuilder,
LuceneIndexSchemaNodeContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractLuceneIndexSchemaObjectNodeBuilder parent;
    private final String absoluteFieldPath;
    private final ObjectFieldStorage storage;
    private boolean multiValued = false;
    private LuceneIndexObjectFieldReference reference;

    LuceneIndexSchemaObjectFieldNodeBuilder(AbstractLuceneIndexSchemaObjectNodeBuilder parent, String relativeFieldName, ObjectFieldStorage storage) {
        this.parent = parent;
        this.absoluteFieldPath = LuceneFields.compose(parent.getAbsolutePath(), relativeFieldName);
        this.storage = storage;
    }

    public EventContext getEventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void multiValued() {
        this.multiValued = true;
    }

    public IndexObjectFieldReference toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.getEventContext());
        }
        this.reference = new LuceneIndexObjectFieldReference(this.storage);
        return this.reference;
    }

    @Override
    public void contribute(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.getEventContext());
        }
        LuceneIndexSchemaObjectNode node = new LuceneIndexSchemaObjectNode(parentNode, this.absoluteFieldPath, this.storage, this.multiValued);
        collector.collectObjectNode(this.absoluteFieldPath, node);
        this.reference.enable(node);
        this.contributeChildren(node, collector);
    }

    @Override
    public LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

